#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Alien Tech 2Mod01.fsh   by   Kali
//https://www.shadertoy.com/view/3t3XRS
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define aa 3

mat2 rot(float a) {
	float s=sin(a);
    float c=cos(a);
    return mat2(c,s,-s,c);
}

vec3 fractal(vec2 p) {
    float c=cos(iTime*.1);
    p.x+=smoothstep(.5,1.,abs(c))*sign(c)*2.;
    p*=.4;
    p.y+=iTime*.05+1.5;
	float v=(floor(mod(p.y,10.))+smoothstep(.9,1.,fract(p.y)))*.1;
    p=abs(.5-fract(p*.5));
    vec2 m=vec2(100.);
    float s=100.,t=s;
    for (int i=0; i<10; i++) {
		p=abs(p+2.)-abs(p-2.)-p;
        p.x-=3.;
        p=p*2.5/clamp(dot(p,p),.2,1.)-1.5-v;
        m=min(m,abs(p));
        s=min(s,length(p*p*p)*.1);
		t=min(t,length(p));
    }
    s=1.-abs(.5-fract(s))*2.;
    t=pow(max(0.,1.-t),2.);
    s-=mod(p.x*.7+1.,16.)*.05;
    m*=rot(-iTime+p.y*.1);
    m=normalize(abs(m));
	return vec3(m*m*3.,1.)*smoothstep(0.,3.,atan(m.x,m.y))+.3-s*s*s*10.+t;
}
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord-iResolution.xy*.5)/iResolution.y;
    uv.x*=sqrt(1.+uv.y);
    uv.y*=sqrt(1.5+uv.y);
    vec3 col = vec3(0.);    
    for (int i=-aa; i<aa; i++) {
        for (int j=-aa; j<aa; j++) {
    		col+=fractal(uv+vec2(i,j)*1./iResolution.xy/float(aa));
        }
    }    
    col*=(1.3-abs(uv.x))*vec3(1.,.7,.4)/float(aa*aa)*.15*smoothstep(0.,1.,iTime);
	col*=max(0.2,1.-uv.y);
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

